<?php $__env->startSection('content'); ?>
    <section class="support-tickets-section ptb-60">
        <div class="container">
            <div class="support-tickets">
                <div class="table-area">
                    <div class="table-wrapper">
                        <div class="dashboard-header-wrapper">
                            <h4 class="title"><?php echo e(__('Support Tickets')); ?></h4>
                            <div class="dashboard-btn-wrapper">
                                <div class="dashboard-btn">
                                    <a href="<?php echo e(route('user.support.ticket.create')); ?>" class="btn--base"><i
                                            class="las la-plus me-1"></i> <?php echo e(__('Add New')); ?></a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="custom-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Ticket ID')); ?></th>
                                        <th><?php echo e(__('Subject')); ?></th>
                                        <th><?php echo e(__('Message')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Last Reply')); ?></th>
                                        <th><?php echo e(__('Created At')); ?></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $support_tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>#<?php echo e($item->token); ?></td>
                                            <td><?php echo e($item->subject); ?></td>
                                            <td><?php echo e(Str::words($item->desc, 10, '...')); ?></td>
                                            <td>
                                                <span class="<?php echo e($item->stringStatus->class); ?>">
                                                    <?php echo e($item->stringStatus->value); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php if(getReply($item->id) != null): ?>
                                                    <?php echo e(getReply($item->id)->created_at->diffForHumans()); ?>

                                                <?php else: ?>
                                                    <?php echo e(__('Not replyed yet ')); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($item->created_at->format('Y-m-d H:i A')); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('user.support.ticket.conversation', encrypt($item->id))); ?>"
                                                    class="btn btn--base"><i class="las la-comment"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center"><span class="text-warning"><?php echo e(__('No Data Found!')); ?></span></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php echo e(get_paginate($support_tickets)); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/support-ticket/index.blade.php ENDPATH**/ ?>