<?php
    $current_url = URL::current();
    $pages = App\Models\Admin\SetupPage::where(['status' => true])
        ->orWhere('slug', 'home')
        ->get();
?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Header
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<header class="header-section two">
    <div class="header">
        <div class="header-bottom-area">
            <div class="container custom-container">
                <div class="header-menu-content">
                    <nav class="navbar navbar-expand-lg p-0">
                        <a class="site-logo site-title" href="<?php echo e(setRoute('frontend.index')); ?>">
                            <img src="<?php echo e(get_logo($basic_settings)); ?>"
                                data-white_img="<?php echo e(get_logo($basic_settings, 'white')); ?>"
                                data-dark_img="<?php echo e(get_logo($basic_settings, 'dark')); ?>" alt="site-logo">
                        </a>
                        <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                            aria-expanded="false" aria-label="Toggle navigation">
                            <span class="fas fa-bars"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav main-menu ms-auto">
                                <?php
                                    $current_url = URL::current();
                                ?>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $title = json_decode($item->title);
                                    ?>
                                    <li>
                                        <a href="<?php echo e(url($item->url)); ?>"
                                            class="<?php if($current_url == url($item->url)): ?> active <?php endif; ?>">
                                            <span><?php echo e(__($item->title)); ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="header-language">
                                <?php
                                    $session_lan = session('local') ?? get_default_language_code();
                                ?>
                                <div class="language-select">
                                    <select class="form--control nice-select" name="lang_switcher">
                                        <?php $__currentLoopData = $__languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->code); ?>"
                                                <?php if($session_lan == $item->code): ?> <?php if(true): echo 'selected'; endif; ?> <?php endif; ?>>
                                                <?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <?php if(Auth::check()): ?>
                                <div class="header-action dashboard-dropdown-btn">
                                    <?php if(auth()->user()->image): ?>
                                        <a href="javascript:void(0);" class="profile-action-btn">
                                            <img src="<?php echo e(get_image(auth()->user()->image, 'user-profile')); ?>"
                                                alt="img">
                                        </a>
                                    <?php else: ?>
                                        <a href="javascript:void(0);" class="profile-action-btn">
                                            <img src="<?php echo e(asset('public/frontend/images/default/profile-default.webp')); ?>"
                                                alt="img">
                                        </a>
                                    <?php endif; ?>
                                    <div class="dropdown-btn-list">
                                        <ul class="dropdown-list-item">
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.profile.index')); ?>"><?php echo e(__('My Profile')); ?></a>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.profile.password')); ?>"><?php echo e(__('Change Password')); ?></a>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.gift.card.index')); ?>"><?php echo e(__('Buy Giftcard')); ?></a>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.mobile.topup.automatic.index')); ?>"><?php echo e(__('Mobile Topup')); ?></a>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.security.google.2fa')); ?>"><?php echo e(__('2FA Verification')); ?></a>
                                                </div>
                                            </li>
                                            <?php if($basic_settings->kyc_verification): ?>
                                                <li>
                                                    <div class="title-area">
                                                        <a
                                                            href="<?php echo e(setRoute('user.kyc.index')); ?>"><?php echo e(__('KYC Verification')); ?></a>
                                                    </div>
                                                </li>
                                            <?php endif; ?>
                                            <li>
                                                <div class="title-area">
                                                    <a
                                                        href="<?php echo e(setRoute('user.support.ticket.index')); ?>"><?php echo e(__('Support')); ?></a>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="title-area">
                                                    <a class="logout-btn"
                                                        href="javascript:void(0)"><?php echo e(__('Logout')); ?></a>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="header-action">
                                    <a href="<?php echo e(setRoute('user.login')); ?>" class="btn--base"><?php echo e(__('Login Now')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Header
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php $__env->startPush('script'); ?>
    <script>
        $(".logout-btn").click(function() {
            var actionRoute = "<?php echo e(setRoute('user.logout')); ?>";
            var target = 1;
            var message = `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('Logout')); ?></strong>?`;
            openAlertModal(actionRoute, target, message, "<?php echo e(__('Logout')); ?>", "POST");
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\xampp\htdocs\Payload\resources\views/user/partials/top-nav.blade.php ENDPATH**/ ?>