<section class="profile-section ptb-80">
    <div class="container">
        <div class="profile-section-area">
            <div class="row mb-30-none align-items-center">
                <div class="col-xl-7 col-lg-8 col-md-12 col-sm-12 mb-30">
                    <div class="user-profile">
                        <div class="user-account-details">
                            <div class="user-balance">
                                <div class="balance-area">
                                    <label><?php echo e(__(get_amount($user_wallet->balance))); ?></label>
                                    <label class="text--base pt-1"><?php echo e(__(get_default_currency_code())); ?></label>
                                </div>
                            </div>
                            <div class="user-account">
                                <label><?php echo e(__('Welcome back')); ?>,
                                    <span><b><?php echo e(__(auth()->user()->username)); ?></b></span></label>
                                <h3 class="title"><?php echo e(__(auth()->user()->full_mobile)); ?></h3>
                                <a href="<?php echo e(setRoute('user.purchase.history')); ?>"><i class="las la-history"></i>
                                    <?php echo e(__('Purchase History')); ?></a>
                                <a href="<?php echo e(setRoute('user.recharge.history')); ?>"><i class="las la-history"></i>
                                    <?php echo e(__('Recharge History')); ?></a>
                            </div>
                        </div>
                        <div class="reacharge-opestion">
                            <form action="<?php echo e(setRoute('user.recharge.submit.amount')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="number" name="amount" class="form--control" placeholder="<?php echo e(__('Enter Amount')); ?>">
                                <div class="reacharge-amount">
                                    <button type="submit" class="btn--base"><?php echo e(__('Add Money')); ?></button>
                                </div>
                            </form>
                        </div>
                        <div class="quick-reacharge">
                            <div class="quick-recharge-tag">
                                <label><?php echo e(__('Quick Add Money')); ?> :</label>
                            </div>
                            <div class="quick-reacharge-amount">
                                <?php $__empty_1 = true; $__currentLoopData = $quick_bttns->buttons->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bttn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="recharge-amount">
                                    <input type="radio" name="q-recharge" data-recharge-value="<?php echo e($bttn->amount); ?>" class="hide-input"
                                        id="recharge-<?php echo e($loop->iteration); ?>">
                                    <label for="recharge-<?php echo e($loop->iteration); ?>" class="recharge--amount">
                                        <p><?php echo e(__($bttn->amount)); ?> <?php echo e(get_default_currency_code()); ?></p>
                                    </label>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-4 col-md-12 col-sm-12 mb-30">
                    <div class="user-balance-details">
                        <div class="row mb-20-none">
                            <div class="col-lg-12 mb-20">
                                <div class="available-balance">
                                    <div class="left">
                                        <span><?php echo e($mobile_topup_count); ?></span>
                                        <p><?php echo e(__('Total Mobile Topup')); ?></p>
                                    </div>
                                    <div class="right">
                                        <i class="las la-phone-alt"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-20">
                                <div class="available-balance">
                                    <div class="left">
                                        <span><?php echo e($giftcard_count); ?></span>
                                        <p><?php echo e(__('Total Giftcard')); ?></p>
                                    </div>
                                    <div class="right">
                                        <i class="las fas fa-gift"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-20">
                                <div class="available-balance">
                                    <div class="left">
                                        <span><?php echo e(__($add_money_count)); ?></span>
                                        <p><?php echo e(__('Total Add Money')); ?></p>
                                    </div>
                                    <div class="right">
                                        <i class="las fas fa-wallet"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script'); ?>
    <script>
        $(function() {
            var $rechargeInput = $('[name=amount]');
            $('[name=q-recharge]').on('click', function() {
                $rechargeInput.val($(this).data('recharge-value'));
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/dashboard-profile/dashboard-profile.blade.php ENDPATH**/ ?>