<?php
$defualt = get_default_language_code() ?? 'en';
$default_lng = 'en';
?>
<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('user.dashboard'),
            ],
        ],
        'active' => __(),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="gift-card-section ptb-80">
        <div class="container">
            <div class="section-title">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <h2 class="title"><?php echo e(__('Send Gift Card')); ?></h2>
                        <p><?php echo e(__($section_data->value->language->$defualt->description ?? $section_data->value->language->$default_lng->description)); ?>

                        </p>
                    </div>
                </div>
                <div class="searching-giftcard mt-20">
                    <p><?php echo e(__("Choose recipient's country to select gift cards.")); ?></p>
                    <div class="select-area">
                        <form action="<?php echo e(setRoute('user.gift.card.search')); ?>" method="GET">
                            <div class="row mb-20-none">
                                <div class="col-xl-4 col-lg-12 col-md-12 mb-20">
                                    <select class="select2-auto-tokenize" name="country">
                                        <option selected><?php echo e('Chosee a country'); ?></option>
                                        <?php $__currentLoopData = get_all_countries(global_const()::USER) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->iso2); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-xl-2 col-lg-4 col-md-4 mb-20">
                                    <div class="search-btn">
                                        <button type="submit" class="btn--base w-100"><?php echo e(__('Search Now')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="choice-gitcard-area pt-40">
                        <div class="row justify-content-center mb-20-none">
                            <?php $__empty_1 = true; $__currentLoopData = $products ??[]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $image = $card['logoUrls'][0];
                                ?>
                                <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 mb-20">
                                    <a href="<?php echo e(setRoute('user.gift.card.details', $card['productId'])); ?>">
                                        <div class="gift-card-img">
                                            <img src="<?php echo e($image ?? ''); ?>" alt="card">
                                        </div>
                                        <div class="gift-card-content">
                                            <h5 class="title"><a
                                                    href=" <?php echo e(setRoute('user.gift.card.details', $card['productId'])); ?>"><?php echo e($card['productName']); ?></a>
                                            </h5>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                            <?php if(count($products ?? []) > 0): ?>
                                <?php echo e($products->withQueryString()->setPath(url()->current())->links('pagination::bootstrap-5')); ?>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/gift-card/search.blade.php ENDPATH**/ ?>