<!-- Purchase History -->
<section class="purchase-history-section ptb-80">
    <div class="container">
        <div class="purchase-history-area">
            <div class="dashboard-list-area">
                <div class="dashboard-header-wrapper">
                    <h3 class="title"><?php echo e(__('Your Purchase History')); ?></h3>
                </div>
            </div>
            <div class="purchase-model-type">
                <?php $__empty_1 = true; $__currentLoopData = $purchase_type ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="purchase-type">
                        <input type="radio" name="<?php echo e($item->type); ?>" class="hide-input" id="<?php echo e($item->type); ?>">
                        <label class="switch <?php if($loop->iteration === 1): ?> switch-active <?php endif; ?>"
                            for="<?php echo e($item->type); ?>">
                            <p><?php echo e(__($item->type)); ?></p>
                        </label>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?>
            </div>
            <div class="history-sections">
                <?php $__empty_1 = true; $__currentLoopData = $purchase_type ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="history <?php if($loop->iteration != 1): ?> d-none <?php endif; ?>" id="div-<?php echo e($item->type); ?>">
                        <div class="row">
                            <div class="col-lg-8 col-md-10">
                                <div class="table-responsive">
                                    <?php
                                        $data = getHistory($item->type);
                                    ?>
                                    <table class="table table-striped custom-table">
                                        <thead>
                                            <tr>
                                                <th scope="col"><?php echo e(__('Volume')); ?></th>
                                                <th scope="col"><?php echo e(__('Price')); ?></th>
                                                <?php if($item->type === 'MOBILE-TOPUP'): ?>
                                                    <th scope="col"><?php echo e(__('Mobile Number')); ?></th>
                                                <?php endif; ?>
                                                <th scope="col"><?php echo e(__('Date')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody id="data-container-<?php echo e($item->type); ?>">
                                            <?php if($data->count()): ?>
                                                <?php $__empty_2 = true; $__currentLoopData = $data?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                    <tr>
                                                        <th <?php if($loop->iteration % 2 === 0): ?> scope="row" <?php endif; ?>>
                                                            <?php echo e($history->request_amount); ?>

                                                            <?php echo e($history->request_currency); ?></th>
                                                        <td><?php echo e($history->total_payable); ?>

                                                            <?php echo e(get_default_currency_code()); ?></td>
                                                        <?php if($item->type === 'MOBILE-TOPUP'): ?>
                                                            <td><?php echo e($history->details->mobile_number); ?></td>
                                                        <?php endif; ?>
                                                        <td><?php echo e(date('Y-m-d', strtotime($history->created_at))); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                    <tr class="text-center">
                                                        <td <?php if($item->type === 'MOBILE-TOPUP'): ?> colspan="4" <?php else: ?> colspan="3" <?php endif; ?> ><?php echo e(__('Nothing to show yet')); ?></td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <tr class="text-center">
                                                    <td <?php if($item->type === 'MOBILE-TOPUP'): ?> colspan="4" <?php else: ?> colspan="3" <?php endif; ?>><?php echo e(__('Nothing to show yet')); ?></td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                    <div class="pagination-links" id="pagination-<?php echo e($item->type); ?>">
                                        <?php echo e($data->links(null, [], null, null, $item->type)); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center text-warning">
                        <?php echo e(__('Nothing to show yet')); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            var $bttns = $(".hide-input");
            var $tbls = $(".history");
            var $switch = $(".switch");

            $bttns.each(function() {
                var $input = $(this);
                $input.on('click', function() {
                    var $tbl = $(`#div-${$input.attr('id')}`);
                    $tbls.addClass("d-none");
                    $tbl.toggleClass("d-none");
                    $switch.removeClass("switch-active");
                    $input.siblings().addClass('switch-active');
                });
            });
        });
    </script>
    <script>
        $(document).on('click', '.pagination-links a', function(e) {
            e.preventDefault(); // Prevent default link behavior

            var url = $(this).attr('href'); // Get the URL of the clicked pagination link
            var type = $(this).closest('.pagination-links').attr('id').replace('pagination-',
                ''); // Extract type from ID

            // Perform the AJAX request
            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    console.log(url)
                    // Replace the content of the table body and pagination links with the new data
                    $('#data-container-' + type).html($(response).find('#data-container-' + type)
                        .html());
                    $('#pagination-' + type).html($(response).find('#pagination-' + type).html());
                },
                error: function(xhr) {
                    alert('Something went wrong, please try again.');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/purchase-history/purchase-history-section.blade.php ENDPATH**/ ?>