<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __("Bundle Details")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Bundle Details'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__($page_title)); ?></h6>
    </div>
    <div class="card-body">
        <form class="card-form">
            <div class="row align-items-center mb-10-none">
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list-two">
                        <li class="one"><?php echo e(__("Date")); ?>: <span><?php echo e(@$data->created_at->format('d-m-y h:i:s A')); ?></span></li>
                        <li class="two"><?php echo e(__("Fullname")); ?>: <span>
                            <?php if($data->user_id != null): ?>
                            <a href="<?php echo e(setRoute('admin.users.details',$data->user->username)); ?>"><?php echo e($data->user->fullname); ?> (<?php echo e(__("USER")); ?>)</a>
                            <?php endif; ?>
                            </span>
                        </li>
                        <li class="three"><?php echo e(__("TopUp Type")); ?>: <span class="fw-bold"><?php echo e(@$data->details->topup_type_name); ?></span></li>
                        <li class="four"><?php echo e(__("Mobile Number")); ?>: <span class="fw-bold"><?php echo e(@$data->details->mobile_number); ?></span></li>
                        <li class="five"><?php echo e(__("Topup Amount")); ?>: <span class="fw-bold"><?php echo e(get_amount($data->request_amount,$data->request_currency)); ?></span></li>

                    </ul>
                </div>
                <div class="col-xl-4 col-lg-4 form-group">
                    <div class="user-profile-thumb">
                        <img src="<?php echo e(get_image(@$default_currency->flag,'currency-flag')); ?>" alt="payment">
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list two">
                        <li class="one"><?php echo e(__("Exchange Rate")); ?>: <span><?php echo e($data->exchange_rate); ?></span></li>
                        <li class="two"><?php echo e(__("Total Charge")); ?>: <span><?php echo e(get_amount($data->total_charge,$data->payment_currency ?? '')); ?></span></li>
                        <li class="three"><?php echo e(__("Payable Amount")); ?>: <span><?php echo e(get_amount($data->total_payable,$data->payment_currency)); ?></span></li>
                        <li class="three"><?php echo e(__("Remaining Balance")); ?>: <span><?php echo e(get_amount($data->available_balance,$data->payment_currency)); ?></span></li>
                        <li class="four"><?php echo e(__("Status")); ?>:  <span class="<?php echo e(@$data->stringStatus->class); ?>"><?php echo e(__(@$data->stringStatus->value)); ?></span></li>
                    </ul>
                </div>
            </div>
        </form>
    </div>
</div>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function(){
        <?php if($errors->any()): ?>
        var modal = $('#rejectModal');
        modal.modal('show');
        <?php endif; ?>
    });
</script>
<script>
     (function ($) {
        "use strict";
        $('.approvedBtn').on('click', function () {
            var modal = $('#approvedModal');
            modal.modal('show');
        });
        $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.modal('show');
        });
    })(jQuery);





</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Payload\resources\views/admin/sections/data-bundles/details.blade.php ENDPATH**/ ?>