<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                            Start body overlay
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
    <div id="body-overlay" class="body-overlay"></div>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                            End body overlay
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                            Start Scroll-To-Top
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
    <a href="#" class="scrollToTop">
        <i class="las la-hand-point-up"></i>
        <small><?php echo e(__('top')); ?></small>
    </a>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                            End Scroll-To-Top
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

    <section class="login-account-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-7 col-md-10 col-sm-12">
                    <div class="login-section-area">
                        <form action="<?php echo e(setRoute('user.login.submit')); ?>" class="account-form" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-logo">
                                <a href="<?php echo e(setroute('frontend.index')); ?>">
                                    <img src="<?php echo e(get_logo($basic_settings)); ?>"
                                        data-white_img="<?php echo e(get_logo($basic_settings, 'white')); ?>"
                                        data-dark_img="<?php echo e(get_logo($basic_settings, 'dark')); ?>" alt="logo">
                                </a>
                            </div>
                            <div class="form-header">
                                <h3 class="title text-center"><?php echo e(__('Log in and Stay Connected')); ?></h3>
                            </div>
                            <div class="access-btn">
                                <h4 class="title"><?php echo e(__('Login With')); ?></h4>
                                <div class="switch-field">
                                    <input type="radio" id="radio-one" name="switch_one" value="OTP" checked />
                                    <label for="radio-one"><?php echo e(__('OTP')); ?></label>
                                    <input type="radio" id="radio-two" name="switch_one" value="Password" />
                                    <label for="radio-two"><?php echo e(__('Password')); ?></label>
                                </div>
                            </div>
                            <div class="otp-login-form" id="otp-login-form">
                                <div class="account-number country-code">
                                    <label><?php echo e(__('Phone Number')); ?>:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <select class="input-group-text copytext nice-select" name="otp_country">
                                                <?php $__currentLoopData = get_all_countries_array(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e(get_country_phone_code($item['name'])); ?>">
                                                        <?php echo e($item['name']); ?> (<?php echo e($item['mobile_code']); ?>)</option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <input type="tel" type="number" class="form--control" name="otp_number"
                                                placeholder="Enter Number" id="phone-number">
                                        </div>
                                    </div>
                                </div>
                                <div class="custom-check-group pt-20">
                                    <input type="checkbox" id="level-112" name="stay">
                                    <label for="level-112"><?php echo e(__('Stay Login Next Time.')); ?></label>
                                </div>
                                <div class="login-btn">
                                    <button type="submit" class="btn--base w-100"><?php echo e(__('Continue')); ?></button>
                                </div>
                                <?php if($basic_settings->user_registration): ?>
                                    <div class="register-page">
                                        <div class="account-item">
                                            <label><?php echo e(__("Don't Have An Account?")); ?> <a
                                                    href="<?php echo e(setRoute('user.register')); ?>"
                                                    class="account-control-btn"><?php echo e(__('Register Now')); ?></a></label>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="passwoard-login-area" id="password-login-area" style="display: none;">
                                <div class="account-number mb-20">
                                    <label><?php echo e(__('Phone Number')); ?>:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <select class="input-group-text copytext nice-select" name="pass_country"
                                                id="">
                                                <?php $__currentLoopData = get_all_countries_array(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e(get_country_phone_code($item['name'])); ?>">
                                                        <?php echo e($item['name']); ?> (<?php echo e($item['mobile_code']); ?>)</option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <input type="tel" class="form--control" name="password_number"
                                            placeholder="Enter Number" value="123456789">
                                        </div>
                                    </div>
                                    <div class="account-passwoard show_hide_password mt-20">
                                        <label><?php echo e(__('Password')); ?>:</label>
                                        <input type="password" class=" form--control" name="password"
                                            placeholder="Enter Password..." value="appdevs">
                                        <a href="#0" class="show-pass"><i class="fa fa-eye-slash"
                                                aria-hidden="true"></i></a>
                                    </div>
                                    <div class="forgot-item text-end">
                                        <span><a href="<?php echo e(setRoute('user.password.forgot')); ?>"
                                                class="text--base"><?php echo e(__('Forgot Password?')); ?></a></span>
                                    </div>
                                    <div class="custom-check-group">
                                        <input type="checkbox" id="level-141" name="remember">
                                        <label for="level-141"><?php echo e(__('Remember Me')); ?></label>
                                    </div>
                                    <div class="login-btn">
                                        <button type="submit" class="btn--base w-100"><?php echo e(__('Continue')); ?></button>
                                    </div>
                                    <?php if($basic_settings->user_registration): ?>
                                        <div class="register-page">
                                            <div class="account-item">
                                                <label><?php echo e(__("Don't Have An Account?")); ?> <a
                                                        href="<?php echo e(setRoute('user.register')); ?>"
                                                        class="account-control-btn"><?php echo e(__('Register Now')); ?></a></label>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        // Function to update the display based on the selected login option
        function updateLoginForm() {
            const otpForm = document.getElementById('otp-login-form');
            const passwordForm = document.getElementById('password-login-area');
            const otpRadio = document.getElementById('radio-one');

            if (otpRadio.checked) {
                otpForm.style.display = 'block';
                passwordForm.style.display = 'none';
            } else {
                otpForm.style.display = 'none';
                passwordForm.style.display = 'block';
            }
        }

        // Add event listeners to the radio buttons
        document.getElementById('radio-one').addEventListener('change', updateLoginForm);
        document.getElementById('radio-two').addEventListener('change', updateLoginForm);

        // Initial call to set the correct display on page load
        updateLoginForm();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Payload\resources\views/user/auth/login.blade.php ENDPATH**/ ?>