<!-- Purchase History -->
<section class="purchase-history-section ptb-80">
    <div class="container">
        <div class="purchase-history-area">
            <div class="dashboard-list-area">
                <div class="dashboard-header-wrapper">
                    <h3 class="title"><?php echo e(__('Your Recharge History')); ?></h3>
                </div>
            </div>
            <div class="history-sections">
                <div class="internet-history">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive">
                                <table class="table table-striped custom-table">
                                    <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(__('SL')); ?></th>
                                            <th scope="col"><?php echo e(__('Recharge amount')); ?></th>
                                            <th scope="col"><?php echo e(__('Total cost')); ?></th>
                                            <th scope="col"><?php echo e(__('Paid with')); ?></th>
                                            <th scope="col"><?php echo e(__('TRX type')); ?></th>
                                            <th scope="col"><?php echo e(__('Status')); ?></th>
                                            <th scope="col"><?php echo e(__('Date')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <th><?php echo e($loop->iteration); ?></th>
                                                <th><?php echo e(get_amount($value->request_amount, get_default_currency_code())); ?>

                                                </th>
                                                <td><?php echo e(get_amount($value->total_payable, $value->payment_currency)); ?>

                                                </td>
                                                <td><?php echo e($value->gateway_currency->name); ?></td>
                                                <td><?php echo e($value->gateway_currency->gateway->type); ?></td>
                                                <td>
                                                    <?php if($value->status === 1): ?>
                                                        <p><?php echo e(__('Complete')); ?></p>
                                                    <?php elseif($value->status === 2): ?>
                                                        <p><?php echo e(__('Pending')); ?></p>
                                                    <?php elseif($value->status === 4): ?>
                                                        <p><?php echo e(__('Canceled')); ?></p>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($value->created_at); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <th class="text-center" colspan="7"><?php echo e(__('Nothing to show yet')); ?></th>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                <?php if(count($transactions ?? []) > 0): ?>
                                    <?php echo e($transactions->withQueryString()->setPath(url()->current())->links('pagination::bootstrap-5')); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/recharge-history/recharge-history-section.blade.php ENDPATH**/ ?>