@extends('admin.layouts.master')

@push('css')
@endpush

@section('page-title')
    @include('admin.components.page-title', ['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __($page_title),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title">{{ __('Mobile Topup Api') }}</h6>
        </div>
        <div class="card-body">
            <form class="card-form" action="{{ setRoute('admin.mobile.topup.method.automatic.api.update') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row mb-10-none">
                    <div class="col-xl-12 col-lg-12 form-group">
                        <label>{{ __('name') }}*</label>
                        <select class="form--control nice-select" name="api_method">
                            <option disabled>{{ __('Select Platfrom') }}</option>
                            <option value="reloadly" @if (@$api->config->name == 'reloadly') selected @endif>@lang('Reloadly Api')
                            </option>
                        </select>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group configForm" id="reloadly">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label>{{ __('Client ID') }}*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-key"></i></span>
                                    <input type="text" class="form--control" name="reloadly_client_id"
                                        value="{{ @$api->credentials->client_id }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label>{{ __('secret Key') }}*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-key"></i></span>
                                    <input type="text" class="form--control" name="reloadly_secret_key"
                                        value="{{ @$api->credentials->secret_key }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label>{{ __('Production URL') }}*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-link"></i></span>
                                    <input type="text" class="form--control" name="reloadly_production_base_url"
                                        value="{{ @$api->credentials->production_base_url }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label>{{ __('Sandbox URL') }}*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-link"></i></span>
                                    <input type="text" class="form--control" name="reloadly_sandbox_base_url"
                                        value="{{ @$api->credentials->sandbox_base_url }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label>{{ __('Webhook URL') }}</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-link"></i></span>
                                    <input type="text" class="form--control" id="referralURL"
                                        value="{{ setRoute('user.data.bundle.webhook') }}" readonly>
                                    <div class="input-group-text copytext" id="copyBoard"><i class="las la-copy"></i></div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                @include('admin.components.form.switcher', [
                                    'label' => __('Api ENV') . '*',
                                    'value' => old('    ', @$api->env),
                                    'name' => 'reloadly_env',
                                    'options' => [
                                        __('Production') => global_const()::ENV_PRODUCTION,
                                        __('Sandbox') => global_const()::ENV_SANDBOX,
                                    ],
                                ])
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group mt-4">
                                @include('admin.components.button.form-btn', [
                                    'class' => 'w-100 btn-loading',
                                    'text' => __('Update'),
                                    'permission' => 'admin.virtual.card.api.update',
                                ])
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection


@push('script')
    <script>
        $('.copytext').on('click', function() {
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");

            throwMessage('success', ['{{ __('URL Copied To Clipboard!') }}']);
        });
    </script>
@endpush
