<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\ExchangeRate;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ExchangeRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $exchange_rates = array(
            array('id' => '1','name' => 'Afghanistan','mobile_code' => '93','currency_name' => 'Afghan afghani','currency_code' => 'AFN','currency_symbol' => '؋','rate' => '73.90411100','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '2','name' => 'Aland Islands','mobile_code' => '+358-18','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '0.95000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '3','name' => 'Albania','mobile_code' => '355','currency_name' => 'Albanian lek','currency_code' => 'ALL','currency_symbol' => 'Lek','rate' => '100.16000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '4','name' => 'Algeria','mobile_code' => '213','currency_name' => 'Algerian dinar','currency_code' => 'DZD','currency_symbol' => 'دج','rate' => '136.86000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '5','name' => 'United States','mobile_code' => '1','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '6','name' => 'American Samoa','mobile_code' => '+1-684','currency_name' => 'US Dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '2.80000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '7','name' => 'Andorra','mobile_code' => '376','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '0.95000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '8','name' => 'Angola','mobile_code' => '244','currency_name' => 'Angolan kwanza','currency_code' => 'AOA','currency_symbol' => 'Kz','rate' => '828.50000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '9','name' => 'Anguilla','mobile_code' => '+1-264','currency_name' => 'East Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '2.70000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '10','name' => 'Antarctica','mobile_code' => '672','currency_name' => 'Antarctican dollar','currency_code' => 'AAD','currency_symbol' => '$','rate' => '3.67250000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '11','name' => 'Antigua And Barbuda','mobile_code' => '+1-268','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '2.70000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '12','name' => 'Argentina','mobile_code' => '54','currency_name' => 'Argentine peso','currency_code' => 'ARS','currency_symbol' => '$','rate' => '349.82000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '13','name' => 'Armenia','mobile_code' => '374','currency_name' => 'Armenian dram','currency_code' => 'AMD','currency_symbol' => '֏','rate' => '399.71000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '14','name' => 'Aruba','mobile_code' => '297','currency_name' => 'Aruban florin','currency_code' => 'AWG','currency_symbol' => 'ƒ','rate' => '1.80000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '15','name' => 'Australia','mobile_code' => '61','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.58000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '16','name' => 'Austria','mobile_code' => '43','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '0.95000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '17','name' => 'Azerbaijan','mobile_code' => '994','currency_name' => 'Azerbaijani manat','currency_code' => 'AZN','currency_symbol' => 'm','rate' => '1.70000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '18','name' => 'Bahrain','mobile_code' => '973','currency_name' => 'Bahraini dinar','currency_code' => 'BHD','currency_symbol' => '.د.ب','rate' => '0.38000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '19','name' => 'Bangladesh','mobile_code' => '880','currency_name' => 'Bangladeshi taka','currency_code' => 'BDT','currency_symbol' => '৳','rate' => '110.04000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '20','name' => 'Barbados','mobile_code' => '+1-246','currency_name' => 'Barbadian dollar','currency_code' => 'BBD','currency_symbol' => 'Bds$','rate' => '2.02000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '21','name' => 'Belarus','mobile_code' => '375','currency_name' => 'Belarusian ruble','currency_code' => 'BYN','currency_symbol' => 'Br','rate' => '3.29000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:27:05'),
            array('id' => '22','name' => 'Belgium','mobile_code' => '32','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '0.95000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:30:46'),
            array('id' => '23','name' => 'Belize','mobile_code' => '501','currency_name' => 'Belize dollar','currency_code' => 'BZD','currency_symbol' => '$','rate' => '2.01000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:30:46'),
            array('id' => '24','name' => 'Benin','mobile_code' => '229','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '621.30000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:30:46'),
            array('id' => '25','name' => 'Bermuda','mobile_code' => '+1-441','currency_name' => 'Bermudian dollar','currency_code' => 'BMD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '26','name' => 'Bhutan','mobile_code' => '975','currency_name' => 'Bhutanese ngultrum','currency_code' => 'BTN','currency_symbol' => 'Nu.','rate' => '83.06000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:30:46'),
            array('id' => '27','name' => 'Bolivia','mobile_code' => '591','currency_name' => 'Bolivian boliviano','currency_code' => 'BOB','currency_symbol' => 'Bs.','rate' => '6.90000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:30:46'),
            array('id' => '28','name' => 'Bonaire, Sint Eustatius and Saba','mobile_code' => '599','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '29','name' => 'Bosnia and Herzegovina','mobile_code' => '387','currency_name' => 'Bosnia and Herzegovina convertible mark','currency_code' => 'BAM','currency_symbol' => 'KM','rate' => '1.85000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:30:46'),
            array('id' => '30','name' => 'Botswana','mobile_code' => '267','currency_name' => 'Botswana pula','currency_code' => 'BWP','currency_symbol' => 'P','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '31','name' => 'Bouvet Island','mobile_code' => '0055','currency_name' => 'Norwegian Krone','currency_code' => 'NOK','currency_symbol' => 'kr','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '32','name' => 'Brazil','mobile_code' => '55','currency_name' => 'Brazilian real','currency_code' => 'BRL','currency_symbol' => 'R$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '33','name' => 'British Indian Ocean Territory','mobile_code' => '246','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '34','name' => 'Brunei','mobile_code' => '673','currency_name' => 'Brunei dollar','currency_code' => 'BND','currency_symbol' => 'B$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '35','name' => 'Bulgaria','mobile_code' => '359','currency_name' => 'Bulgarian lev','currency_code' => 'BGN','currency_symbol' => 'Лв.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '36','name' => 'Burkina Faso','mobile_code' => '226','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '37','name' => 'Burundi','mobile_code' => '257','currency_name' => 'Burundian franc','currency_code' => 'BIF','currency_symbol' => 'FBu','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '38','name' => 'Cambodia','mobile_code' => '855','currency_name' => 'Cambodian riel','currency_code' => 'KHR','currency_symbol' => 'KHR','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '39','name' => 'Cameroon','mobile_code' => '237','currency_name' => 'Central African CFA franc','currency_code' => 'XAF','currency_symbol' => 'FCFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '40','name' => 'Canada','mobile_code' => '1','currency_name' => 'Canadian dollar','currency_code' => 'CAD','currency_symbol' => '$','rate' => '1.38000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:32:13'),
            array('id' => '41','name' => 'Cape Verde','mobile_code' => '238','currency_name' => 'Cape Verdean escudo','currency_code' => 'CVE','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '42','name' => 'Cayman Islands','mobile_code' => '+1-345','currency_name' => 'Cayman Islands dollar','currency_code' => 'KYD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '43','name' => 'Central African Republic','mobile_code' => '236','currency_name' => 'Central African CFA franc','currency_code' => 'XAF','currency_symbol' => 'FCFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '44','name' => 'Chad','mobile_code' => '235','currency_name' => 'Central African CFA franc','currency_code' => 'XAF','currency_symbol' => 'FCFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '45','name' => 'Chile','mobile_code' => '56','currency_name' => 'Chilean peso','currency_code' => 'CLP','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '46','name' => 'China','mobile_code' => '86','currency_name' => 'Chinese yuan','currency_code' => 'CNY','currency_symbol' => '¥','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '47','name' => 'Christmas Island','mobile_code' => '61','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '48','name' => 'Cocos (Keeling) Islands','mobile_code' => '61','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '49','name' => 'Colombia','mobile_code' => '57','currency_name' => 'Colombian peso','currency_code' => 'COP','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '50','name' => 'Comoros','mobile_code' => '269','currency_name' => 'Comorian franc','currency_code' => 'KMF','currency_symbol' => 'CF','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '51','name' => 'Congo','mobile_code' => '242','currency_name' => 'Central African CFA franc','currency_code' => 'XAF','currency_symbol' => 'FC','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '52','name' => 'Cook Islands','mobile_code' => '682','currency_name' => 'Cook Islands dollar','currency_code' => 'NZD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '53','name' => 'Costa Rica','mobile_code' => '506','currency_name' => 'Costa Rican colón','currency_code' => 'CRC','currency_symbol' => '₡','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '54','name' => 'Cote D\'Ivoire (Ivory Coast)','mobile_code' => '225','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '55','name' => 'Croatia','mobile_code' => '385','currency_name' => 'Croatian kuna','currency_code' => 'HRK','currency_symbol' => 'kn','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '56','name' => 'Cuba','mobile_code' => '53','currency_name' => 'Cuban peso','currency_code' => 'CUP','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '57','name' => 'Curaçao','mobile_code' => '599','currency_name' => 'Netherlands Antillean guilder','currency_code' => 'ANG','currency_symbol' => 'ƒ','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '58','name' => 'Cyprus','mobile_code' => '357','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '59','name' => 'Czech Republic','mobile_code' => '420','currency_name' => 'Czech koruna','currency_code' => 'CZK','currency_symbol' => 'Kč','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '60','name' => 'Democratic Republic of the Congo','mobile_code' => '243','currency_name' => 'Congolese Franc','currency_code' => 'CDF','currency_symbol' => 'FC','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '61','name' => 'Denmark','mobile_code' => '45','currency_name' => 'Danish krone','currency_code' => 'DKK','currency_symbol' => 'Kr.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '62','name' => 'Djibouti','mobile_code' => '253','currency_name' => 'Djiboutian franc','currency_code' => 'DJF','currency_symbol' => 'Fdj','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '63','name' => 'Dominica','mobile_code' => '+1-767','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '64','name' => 'Dominican Republic','mobile_code' => '+1-809 and 1-829','currency_name' => 'Dominican peso','currency_code' => 'DOP','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '65','name' => 'East Timor','mobile_code' => '670','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '66','name' => 'Ecuador','mobile_code' => '593','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '67','name' => 'Egypt','mobile_code' => '20','currency_name' => 'Egyptian pound','currency_code' => 'EGP','currency_symbol' => 'ج.م','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '68','name' => 'El Salvador','mobile_code' => '503','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '69','name' => 'Equatorial Guinea','mobile_code' => '240','currency_name' => 'Central African CFA franc','currency_code' => 'XAF','currency_symbol' => 'FCFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '70','name' => 'Eritrea','mobile_code' => '291','currency_name' => 'Eritrean nakfa','currency_code' => 'ERN','currency_symbol' => 'Nfk','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '71','name' => 'Estonia','mobile_code' => '372','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '72','name' => 'Ethiopia','mobile_code' => '251','currency_name' => 'Ethiopian birr','currency_code' => 'ETB','currency_symbol' => 'Nkf','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '73','name' => 'Falkland Islands','mobile_code' => '500','currency_name' => 'Falkland Islands pound','currency_code' => 'FKP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '74','name' => 'Faroe Islands','mobile_code' => '298','currency_name' => 'Danish krone','currency_code' => 'DKK','currency_symbol' => 'Kr.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '75','name' => 'Fiji Islands','mobile_code' => '679','currency_name' => 'Fijian dollar','currency_code' => 'FJD','currency_symbol' => 'FJ$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '76','name' => 'Finland','mobile_code' => '358','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '77','name' => 'France','mobile_code' => '33','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '78','name' => 'French Guiana','mobile_code' => '594','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '79','name' => 'French Polynesia','mobile_code' => '689','currency_name' => 'CFP franc','currency_code' => 'XPF','currency_symbol' => '₣','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '80','name' => 'French Southern Territories','mobile_code' => '262','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '81','name' => 'Gabon','mobile_code' => '241','currency_name' => 'Central African CFA franc','currency_code' => 'XAF','currency_symbol' => 'FCFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '82','name' => 'Gambia The','mobile_code' => '220','currency_name' => 'Gambian dalasi','currency_code' => 'GMD','currency_symbol' => 'D','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '83','name' => 'Georgia','mobile_code' => '995','currency_name' => 'Georgian lari','currency_code' => 'GEL','currency_symbol' => 'ლ','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '84','name' => 'Germany','mobile_code' => '49','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '85','name' => 'Ghana','mobile_code' => '233','currency_name' => 'Ghanaian cedi','currency_code' => 'GHS','currency_symbol' => 'GH₵','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '86','name' => 'Gibraltar','mobile_code' => '350','currency_name' => 'Gibraltar pound','currency_code' => 'GIP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '87','name' => 'Greece','mobile_code' => '30','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '88','name' => 'Greenland','mobile_code' => '299','currency_name' => 'Danish krone','currency_code' => 'DKK','currency_symbol' => 'Kr.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '89','name' => 'Grenada','mobile_code' => '+1-473','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '90','name' => 'Guadeloupe','mobile_code' => '590','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '91','name' => 'Guam','mobile_code' => '+1-671','currency_name' => 'US Dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '92','name' => 'Guatemala','mobile_code' => '502','currency_name' => 'Guatemalan quetzal','currency_code' => 'GTQ','currency_symbol' => 'Q','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '93','name' => 'Guernsey and Alderney','mobile_code' => '+44-1481','currency_name' => 'British pound','currency_code' => 'GBP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '94','name' => 'Guinea','mobile_code' => '224','currency_name' => 'Guinean franc','currency_code' => 'GNF','currency_symbol' => 'FG','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '95','name' => 'Guinea-Bissau','mobile_code' => '245','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '96','name' => 'Guyana','mobile_code' => '592','currency_name' => 'Guyanese dollar','currency_code' => 'GYD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '97','name' => 'Haiti','mobile_code' => '509','currency_name' => 'Haitian gourde','currency_code' => 'HTG','currency_symbol' => 'G','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '98','name' => 'Heard Island and McDonald Islands','mobile_code' => '672','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '99','name' => 'Honduras','mobile_code' => '504','currency_name' => 'Honduran lempira','currency_code' => 'HNL','currency_symbol' => 'L','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '100','name' => 'Hong Kong S.A.R.','mobile_code' => '852','currency_name' => 'Hong Kong dollar','currency_code' => 'HKD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '101','name' => 'Hungary','mobile_code' => '36','currency_name' => 'Hungarian forint','currency_code' => 'HUF','currency_symbol' => 'Ft','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '102','name' => 'Iceland','mobile_code' => '354','currency_name' => 'Icelandic króna','currency_code' => 'ISK','currency_symbol' => 'kr','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '103','name' => 'India','mobile_code' => '91','currency_name' => 'Indian rupee','currency_code' => 'INR','currency_symbol' => '₹','rate' => '83.24000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:31:16'),
            array('id' => '104','name' => 'Indonesia','mobile_code' => '62','currency_name' => 'Indonesian rupiah','currency_code' => 'IDR','currency_symbol' => 'Rp','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '105','name' => 'Iran','mobile_code' => '98','currency_name' => 'Iranian rial','currency_code' => 'IRR','currency_symbol' => '﷼','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '106','name' => 'Iraq','mobile_code' => '964','currency_name' => 'Iraqi dinar','currency_code' => 'IQD','currency_symbol' => 'د.ع','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '107','name' => 'Ireland','mobile_code' => '353','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '108','name' => 'Israel','mobile_code' => '972','currency_name' => 'Israeli new shekel','currency_code' => 'ILS','currency_symbol' => '₪','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '109','name' => 'Italy','mobile_code' => '39','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '110','name' => 'Jamaica','mobile_code' => '+1-876','currency_name' => 'Jamaican dollar','currency_code' => 'JMD','currency_symbol' => 'J$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '111','name' => 'Japan','mobile_code' => '81','currency_name' => 'Japanese yen','currency_code' => 'JPY','currency_symbol' => '¥','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '112','name' => 'Jersey','mobile_code' => '+44-1534','currency_name' => 'British pound','currency_code' => 'GBP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '113','name' => 'Jordan','mobile_code' => '962','currency_name' => 'Jordanian dinar','currency_code' => 'JOD','currency_symbol' => 'ا.د','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '114','name' => 'Kazakhstan','mobile_code' => '7','currency_name' => 'Kazakhstani tenge','currency_code' => 'KZT','currency_symbol' => 'лв','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '115','name' => 'Kenya','mobile_code' => '254','currency_name' => 'Kenyan shilling','currency_code' => 'KES','currency_symbol' => 'KSh','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '116','name' => 'Kiribati','mobile_code' => '686','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '117','name' => 'Kosovo','mobile_code' => '383','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '118','name' => 'Kuwait','mobile_code' => '965','currency_name' => 'Kuwaiti dinar','currency_code' => 'KWD','currency_symbol' => 'ك.د','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '119','name' => 'Kyrgyzstan','mobile_code' => '996','currency_name' => 'Kyrgyzstani som','currency_code' => 'KGS','currency_symbol' => 'лв','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '120','name' => 'Laos','mobile_code' => '856','currency_name' => 'Lao kip','currency_code' => 'LAK','currency_symbol' => '₭','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '121','name' => 'Latvia','mobile_code' => '371','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '122','name' => 'Lebanon','mobile_code' => '961','currency_name' => 'Lebanese pound','currency_code' => 'LBP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '123','name' => 'Lesotho','mobile_code' => '266','currency_name' => 'Lesotho loti','currency_code' => 'LSL','currency_symbol' => 'L','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '124','name' => 'Liberia','mobile_code' => '231','currency_name' => 'Liberian dollar','currency_code' => 'LRD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '125','name' => 'Libya','mobile_code' => '218','currency_name' => 'Libyan dinar','currency_code' => 'LYD','currency_symbol' => 'د.ل','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '126','name' => 'Liechtenstein','mobile_code' => '423','currency_name' => 'Swiss franc','currency_code' => 'CHF','currency_symbol' => 'CHf','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '127','name' => 'Lithuania','mobile_code' => '370','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '128','name' => 'Luxembourg','mobile_code' => '352','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '129','name' => 'Macau S.A.R.','mobile_code' => '853','currency_name' => 'Macanese pataca','currency_code' => 'MOP','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '130','name' => 'Macedonia','mobile_code' => '389','currency_name' => 'Denar','currency_code' => 'MKD','currency_symbol' => 'ден','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '131','name' => 'Madagascar','mobile_code' => '261','currency_name' => 'Malagasy ariary','currency_code' => 'MGA','currency_symbol' => 'Ar','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '132','name' => 'Malawi','mobile_code' => '265','currency_name' => 'Malawian kwacha','currency_code' => 'MWK','currency_symbol' => 'MK','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '133','name' => 'Malaysia','mobile_code' => '60','currency_name' => 'Malaysian ringgit','currency_code' => 'MYR','currency_symbol' => 'RM','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '134','name' => 'Maldives','mobile_code' => '960','currency_name' => 'Maldivian rufiyaa','currency_code' => 'MVR','currency_symbol' => 'Rf','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '135','name' => 'Mali','mobile_code' => '223','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '136','name' => 'Malta','mobile_code' => '356','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '137','name' => 'Man (Isle of)','mobile_code' => '+44-1624','currency_name' => 'British pound','currency_code' => 'GBP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '138','name' => 'Marshall Islands','mobile_code' => '692','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '139','name' => 'Martinique','mobile_code' => '596','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '140','name' => 'Mauritania','mobile_code' => '222','currency_name' => 'Mauritanian ouguiya','currency_code' => 'MRO','currency_symbol' => 'MRU','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '141','name' => 'Mauritius','mobile_code' => '230','currency_name' => 'Mauritian rupee','currency_code' => 'MUR','currency_symbol' => '₨','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '142','name' => 'Mayotte','mobile_code' => '262','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '143','name' => 'Mexico','mobile_code' => '52','currency_name' => 'Mexican peso','currency_code' => 'MXN','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '144','name' => 'Micronesia','mobile_code' => '691','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '145','name' => 'Moldova','mobile_code' => '373','currency_name' => 'Moldovan leu','currency_code' => 'MDL','currency_symbol' => 'L','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '146','name' => 'Monaco','mobile_code' => '377','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '147','name' => 'Mongolia','mobile_code' => '976','currency_name' => 'Mongolian tögrög','currency_code' => 'MNT','currency_symbol' => '₮','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '148','name' => 'Montenegro','mobile_code' => '382','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '149','name' => 'Montserrat','mobile_code' => '+1-664','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '150','name' => 'Morocco','mobile_code' => '212','currency_name' => 'Moroccan dirham','currency_code' => 'MAD','currency_symbol' => 'DH','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '151','name' => 'Mozambique','mobile_code' => '258','currency_name' => 'Mozambican metical','currency_code' => 'MZN','currency_symbol' => 'MT','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '152','name' => 'Myanmar','mobile_code' => '95','currency_name' => 'Burmese kyat','currency_code' => 'MMK','currency_symbol' => 'K','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '153','name' => 'Namibia','mobile_code' => '264','currency_name' => 'Namibian dollar','currency_code' => 'NAD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '154','name' => 'Nauru','mobile_code' => '674','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '155','name' => 'Nepal','mobile_code' => '977','currency_name' => 'Nepalese rupee','currency_code' => 'NPR','currency_symbol' => '₨','rate' => '132.91000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:34:33'),
            array('id' => '156','name' => 'Netherlands','mobile_code' => '31','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '157','name' => 'New Caledonia','mobile_code' => '687','currency_name' => 'CFP franc','currency_code' => 'XPF','currency_symbol' => '₣','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '158','name' => 'New Zealand','mobile_code' => '64','currency_name' => 'New Zealand dollar','currency_code' => 'NZD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '159','name' => 'Nicaragua','mobile_code' => '505','currency_name' => 'Nicaraguan córdoba','currency_code' => 'NIO','currency_symbol' => 'C$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '160','name' => 'Niger','mobile_code' => '227','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '161','name' => 'Nigeria','mobile_code' => '234','currency_name' => 'Nigerian naira','currency_code' => 'NGN','currency_symbol' => '₦','rate' => '802.70000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:33:47'),
            array('id' => '162','name' => 'Niue','mobile_code' => '683','currency_name' => 'New Zealand dollar','currency_code' => 'NZD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '163','name' => 'Norfolk Island','mobile_code' => '672','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '164','name' => 'North Korea','mobile_code' => '850','currency_name' => 'North Korean Won','currency_code' => 'KPW','currency_symbol' => '₩','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '165','name' => 'Northern Mariana Islands','mobile_code' => '+1-670','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '166','name' => 'Norway','mobile_code' => '47','currency_name' => 'Norwegian krone','currency_code' => 'NOK','currency_symbol' => 'kr','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '167','name' => 'Oman','mobile_code' => '968','currency_name' => 'Omani rial','currency_code' => 'OMR','currency_symbol' => '.ع.ر','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '168','name' => 'Pakistan','mobile_code' => '92','currency_name' => 'Pakistani rupee','currency_code' => 'PKR','currency_symbol' => '₨','rate' => '279.59000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:34:08'),
            array('id' => '169','name' => 'Palau','mobile_code' => '680','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '170','name' => 'Palestinian Territory Occupied','mobile_code' => '970','currency_name' => 'Israeli new shekel','currency_code' => 'ILS','currency_symbol' => '₪','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '171','name' => 'Panama','mobile_code' => '507','currency_name' => 'Panamanian balboa','currency_code' => 'PAB','currency_symbol' => 'B/.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '172','name' => 'Papua new Guinea','mobile_code' => '675','currency_name' => 'Papua New Guinean kina','currency_code' => 'PGK','currency_symbol' => 'K','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '173','name' => 'Paraguay','mobile_code' => '595','currency_name' => 'Paraguayan guarani','currency_code' => 'PYG','currency_symbol' => '₲','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '174','name' => 'Peru','mobile_code' => '51','currency_name' => 'Peruvian sol','currency_code' => 'PEN','currency_symbol' => 'S/.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '175','name' => 'Philippines','mobile_code' => '63','currency_name' => 'Philippine peso','currency_code' => 'PHP','currency_symbol' => '₱','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '176','name' => 'Pitcairn Island','mobile_code' => '870','currency_name' => 'New Zealand dollar','currency_code' => 'NZD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '177','name' => 'Poland','mobile_code' => '48','currency_name' => 'Polish złoty','currency_code' => 'PLN','currency_symbol' => 'zł','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '178','name' => 'Portugal','mobile_code' => '351','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '179','name' => 'Puerto Rico','mobile_code' => '+1-787 and 1-939','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '180','name' => 'Qatar','mobile_code' => '974','currency_name' => 'Qatari riyal','currency_code' => 'QAR','currency_symbol' => 'ق.ر','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '181','name' => 'Reunion','mobile_code' => '262','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '182','name' => 'Romania','mobile_code' => '40','currency_name' => 'Romanian leu','currency_code' => 'RON','currency_symbol' => 'lei','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '183','name' => 'Russia','mobile_code' => '7','currency_name' => 'Russian ruble','currency_code' => 'RUB','currency_symbol' => '₽','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '184','name' => 'Rwanda','mobile_code' => '250','currency_name' => 'Rwandan franc','currency_code' => 'RWF','currency_symbol' => 'FRw','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '185','name' => 'Saint Helena','mobile_code' => '290','currency_name' => 'Saint Helena pound','currency_code' => 'SHP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '186','name' => 'Saint Kitts And Nevis','mobile_code' => '+1-869','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '187','name' => 'Saint Lucia','mobile_code' => '+1-758','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '188','name' => 'Saint Pierre and Miquelon','mobile_code' => '508','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '189','name' => 'Saint Vincent And The Grenadines','mobile_code' => '+1-784','currency_name' => 'Eastern Caribbean dollar','currency_code' => 'XCD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '190','name' => 'Saint-Barthelemy','mobile_code' => '590','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '191','name' => 'Saint-Martin (French part)','mobile_code' => '590','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '192','name' => 'Samoa','mobile_code' => '685','currency_name' => 'Samoan tālā','currency_code' => 'WST','currency_symbol' => 'SAT','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '193','name' => 'San Marino','mobile_code' => '378','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '194','name' => 'Sao Tome and Principe','mobile_code' => '239','currency_name' => 'Dobra','currency_code' => 'STD','currency_symbol' => 'Db','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '195','name' => 'Saudi Arabia','mobile_code' => '966','currency_name' => 'Saudi riyal','currency_code' => 'SAR','currency_symbol' => '﷼','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '196','name' => 'Senegal','mobile_code' => '221','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '197','name' => 'Serbia','mobile_code' => '381','currency_name' => 'Serbian dinar','currency_code' => 'RSD','currency_symbol' => 'din','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '198','name' => 'Seychelles','mobile_code' => '248','currency_name' => 'Seychellois rupee','currency_code' => 'SCR','currency_symbol' => 'SRe','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '199','name' => 'Sierra Leone','mobile_code' => '232','currency_name' => 'Sierra Leonean leone','currency_code' => 'SLL','currency_symbol' => 'Le','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '200','name' => 'Singapore','mobile_code' => '65','currency_name' => 'Singapore dollar','currency_code' => 'SGD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '201','name' => 'Sint Maarten (Dutch part)','mobile_code' => '1721','currency_name' => 'Netherlands Antillean guilder','currency_code' => 'ANG','currency_symbol' => 'ƒ','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '202','name' => 'Slovakia','mobile_code' => '421','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '203','name' => 'Slovenia','mobile_code' => '386','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '204','name' => 'Solomon Islands','mobile_code' => '677','currency_name' => 'Solomon Islands dollar','currency_code' => 'SBD','currency_symbol' => 'Si$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '205','name' => 'Somalia','mobile_code' => '252','currency_name' => 'Somali shilling','currency_code' => 'SOS','currency_symbol' => 'Sh.so.','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '206','name' => 'South Africa','mobile_code' => '27','currency_name' => 'South African rand','currency_code' => 'ZAR','currency_symbol' => 'R','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '207','name' => 'South Georgia','mobile_code' => '500','currency_name' => 'British pound','currency_code' => 'GBP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '208','name' => 'South Korea','mobile_code' => '82','currency_name' => 'Won','currency_code' => 'KRW','currency_symbol' => '₩','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '209','name' => 'South Sudan','mobile_code' => '211','currency_name' => 'South Sudanese pound','currency_code' => 'SSP','currency_symbol' => '£','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '210','name' => 'Spain','mobile_code' => '34','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '211','name' => 'Sri Lanka','mobile_code' => '94','currency_name' => 'Sri Lankan rupee','currency_code' => 'LKR','currency_symbol' => 'Rs','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '212','name' => 'Sudan','mobile_code' => '249','currency_name' => 'Sudanese pound','currency_code' => 'SDG','currency_symbol' => '.س.ج','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '213','name' => 'Suriname','mobile_code' => '597','currency_name' => 'Surinamese dollar','currency_code' => 'SRD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '214','name' => 'Svalbard And Jan Mayen Islands','mobile_code' => '47','currency_name' => 'Norwegian Krone','currency_code' => 'NOK','currency_symbol' => 'kr','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '215','name' => 'Swaziland','mobile_code' => '268','currency_name' => 'Lilangeni','currency_code' => 'SZL','currency_symbol' => 'E','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '216','name' => 'Sweden','mobile_code' => '46','currency_name' => 'Swedish krona','currency_code' => 'SEK','currency_symbol' => 'kr','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '217','name' => 'Switzerland','mobile_code' => '41','currency_name' => 'Swiss franc','currency_code' => 'CHF','currency_symbol' => 'CHf','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '218','name' => 'Syria','mobile_code' => '963','currency_name' => 'Syrian pound','currency_code' => 'SYP','currency_symbol' => 'LS','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '219','name' => 'Taiwan','mobile_code' => '886','currency_name' => 'New Taiwan dollar','currency_code' => 'TWD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '220','name' => 'Tajikistan','mobile_code' => '992','currency_name' => 'Tajikistani somoni','currency_code' => 'TJS','currency_symbol' => 'SM','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '221','name' => 'Tanzania','mobile_code' => '255','currency_name' => 'Tanzanian shilling','currency_code' => 'TZS','currency_symbol' => 'TSh','rate' => '2501.00000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:35:51'),
            array('id' => '222','name' => 'Thailand','mobile_code' => '66','currency_name' => 'Thai baht','currency_code' => 'THB','currency_symbol' => '฿','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '223','name' => 'The Bahamas','mobile_code' => '+1-242','currency_name' => 'Bahamian dollar','currency_code' => 'BSD','currency_symbol' => 'B$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '224','name' => 'Togo','mobile_code' => '228','currency_name' => 'West African CFA franc','currency_code' => 'XOF','currency_symbol' => 'CFA','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '225','name' => 'Tokelau','mobile_code' => '690','currency_name' => 'New Zealand dollar','currency_code' => 'NZD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '226','name' => 'Tonga','mobile_code' => '676','currency_name' => 'Tongan paʻanga','currency_code' => 'TOP','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '227','name' => 'Trinidad And Tobago','mobile_code' => '+1-868','currency_name' => 'Trinidad and Tobago dollar','currency_code' => 'TTD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '228','name' => 'Tunisia','mobile_code' => '216','currency_name' => 'Tunisian dinar','currency_code' => 'TND','currency_symbol' => 'ت.د','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '229','name' => 'Turkey','mobile_code' => '90','currency_name' => 'Turkish lira','currency_code' => 'TRY','currency_symbol' => '₺','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '230','name' => 'Turkmenistan','mobile_code' => '993','currency_name' => 'Turkmenistan manat','currency_code' => 'TMT','currency_symbol' => 'T','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '231','name' => 'Turks And Caicos Islands','mobile_code' => '+1-649','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '232','name' => 'Tuvalu','mobile_code' => '688','currency_name' => 'Australian dollar','currency_code' => 'AUD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '233','name' => 'Uganda','mobile_code' => '256','currency_name' => 'Ugandan shilling','currency_code' => 'UGX','currency_symbol' => 'USh','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '234','name' => 'Ukraine','mobile_code' => '380','currency_name' => 'Ukrainian hryvnia','currency_code' => 'UAH','currency_symbol' => '₴','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '235','name' => 'United Arab Emirates','mobile_code' => '971','currency_name' => 'United Arab Emirates dirham','currency_code' => 'AED','currency_symbol' => 'إ.د','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '236','name' => 'United Kingdom','mobile_code' => '44','currency_name' => 'British pound','currency_code' => 'GBP','currency_symbol' => '£','rate' => '0.82000000','status' => '1','created_at' => NULL,'updated_at' => '2023-10-27 10:33:21'),
            array('id' => '237','name' => 'United States Minor Outlying Islands','mobile_code' => '1','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '238','name' => 'Uruguay','mobile_code' => '598','currency_name' => 'Uruguayan peso','currency_code' => 'UYU','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '239','name' => 'Uzbekistan','mobile_code' => '998','currency_name' => 'Uzbekistani soʻm','currency_code' => 'UZS','currency_symbol' => 'лв','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '240','name' => 'Vanuatu','mobile_code' => '678','currency_name' => 'Vanuatu vatu','currency_code' => 'VUV','currency_symbol' => 'VT','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '241','name' => 'Vatican City State (Holy See)','mobile_code' => '379','currency_name' => 'Euro','currency_code' => 'EUR','currency_symbol' => '€','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '242','name' => 'Venezuela','mobile_code' => '58','currency_name' => 'Bolívar','currency_code' => 'VEF','currency_symbol' => 'Bs','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '243','name' => 'Vietnam','mobile_code' => '84','currency_name' => 'Vietnamese đồng','currency_code' => 'VND','currency_symbol' => '₫','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '244','name' => 'Virgin Islands (British)','mobile_code' => '+1-284','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '245','name' => 'Virgin Islands (US)','mobile_code' => '+1-340','currency_name' => 'United States dollar','currency_code' => 'USD','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '246','name' => 'Wallis And Futuna Islands','mobile_code' => '681','currency_name' => 'CFP franc','currency_code' => 'XPF','currency_symbol' => '₣','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '247','name' => 'Western Sahara','mobile_code' => '212','currency_name' => 'Moroccan Dirham','currency_code' => 'MAD','currency_symbol' => 'MAD','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '248','name' => 'Yemen','mobile_code' => '967','currency_name' => 'Yemeni rial','currency_code' => 'YER','currency_symbol' => '﷼','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '249','name' => 'Zambia','mobile_code' => '260','currency_name' => 'Zambian kwacha','currency_code' => 'ZMW','currency_symbol' => 'ZK','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '250','name' => 'Zimbabwe','mobile_code' => '263','currency_name' => 'Zimbabwe Dollar','currency_code' => 'ZWL','currency_symbol' => '$','rate' => '1.00000000','status' => '1','created_at' => NULL,'updated_at' => NULL)
          );
        ExchangeRate::insert($exchange_rates);
    }
}
