<?php

namespace Database\Seeders\Admin;

use App\Models\Frontend\Blogs;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $blogs = array(
             array('id' => '5','admin_id' => '1','category_id' => '5','slug' => 'how-payload-simplifies-mobile-recharges-and-digital-gifting','data' => '{"language":{"en":{"title":"How PayLoad Simplifies Mobile Recharges and Digital Gifting","description":"<p><span style=\\"background-color:rgb(255,255,255);color:rgb(0,0,0);\\">PayLoad leverages cutting-edge web technologies to deliver a seamless and secure platform for mobile recharges and digital gift card purchases. At its core, it is built on a robust PHP framework, ensuring high performance and scalability. With RESTful APIs, PayLoad integrates with multiple payment gateways and telecom operators, offering real-time transaction processing. The platform employs advanced encryption techniques to secure user data and payments, adhering to global security standards. Its responsive design ensures smooth usability across devices, whether on desktop or mobile. The backend is optimized for efficiency, supporting multiple concurrent transactions without lag. PayLoad\'s intuitive interface makes it easy for users to recharge their mobiles or purchase gift cards in just a few clicks. The admin panel provides comprehensive analytics, helping businesses track user activities and sales performance. By combining technology with user-centric design, PayLoad offers a reliable and future-ready platform.<\\/span><\\/p>","tags":["tech"]},"fr":{"title":"Comment PayLoad simplifie les recharges mobiles et les cadeaux num\\u00e9riques","description":"<p>PayLoad exploite des technologies Web de pointe pour offrir une plate-forme transparente et s\\u00e9curis\\u00e9e pour les recharges mobiles et les achats de cartes-cadeaux num\\u00e9riques. \\u00c0 la base, il repose sur un framework PHP robuste, garantissant des performances et une \\u00e9volutivit\\u00e9 \\u00e9lev\\u00e9es. Gr\\u00e2ce aux API RESTful, PayLoad s\'int\\u00e8gre \\u00e0 plusieurs passerelles de paiement et op\\u00e9rateurs de t\\u00e9l\\u00e9communications, offrant un traitement des transactions en temps r\\u00e9el.&nbsp;<br>La plateforme utilise des techniques de cryptage avanc\\u00e9es pour s\\u00e9curiser les donn\\u00e9es et les paiements des utilisateurs, dans le respect des normes de s\\u00e9curit\\u00e9 mondiales. Sa conception r\\u00e9active garantit une utilisation fluide sur tous les appareils, que ce soit sur ordinateur ou mobile. Le backend est optimis\\u00e9 pour l\\u2019efficacit\\u00e9, prenant en charge plusieurs transactions simultan\\u00e9es sans d\\u00e9calage.&nbsp;<br>L\'interface intuitive de PayLoad permet aux utilisateurs de recharger facilement leurs mobiles ou d\'acheter des cartes cadeaux en quelques clics. Le panneau d\'administration fournit des analyses compl\\u00e8tes, aidant les entreprises \\u00e0 suivre les activit\\u00e9s des utilisateurs et les performances des ventes.&nbsp;<br>En combinant technologie et conception centr\\u00e9e sur l\'utilisateur, PayLoad offre une plateforme fiable et pr\\u00eate pour l\'avenir.<\\/p>"},"es":{"title":"C\\u00f3mo PayLoad simplifica las recargas m\\u00f3viles y los obsequios digitales","description":"<p>PayLoad aprovecha las tecnolog\\u00edas web de vanguardia para ofrecer una plataforma segura y fluida para recargas m\\u00f3viles y compras de tarjetas de regalo digitales. En esencia, est\\u00e1 construido sobre un marco PHP robusto, lo que garantiza un alto rendimiento y escalabilidad. Con las API RESTful, PayLoad se integra con m\\u00faltiples pasarelas de pago y operadores de telecomunicaciones, ofreciendo procesamiento de transacciones en tiempo real.&nbsp;<br>La plataforma emplea t\\u00e9cnicas de cifrado avanzadas para proteger los datos y los pagos de los usuarios, cumpliendo con los est\\u00e1ndares de seguridad globales. Su dise\\u00f1o responsivo garantiza una usabilidad fluida en todos los dispositivos, ya sea en computadoras de escritorio o m\\u00f3viles. El backend est\\u00e1 optimizado para lograr eficiencia y admite m\\u00faltiples transacciones simult\\u00e1neas sin demoras.&nbsp;<br>La interfaz intuitiva de PayLoad facilita a los usuarios recargar sus m\\u00f3viles o comprar tarjetas de regalo con s\\u00f3lo unos pocos clics. El panel de administraci\\u00f3n proporciona an\\u00e1lisis completos que ayudan a las empresas a realizar un seguimiento de las actividades de los usuarios y el rendimiento de las ventas.&nbsp;<br>Al combinar tecnolog\\u00eda con un dise\\u00f1o centrado en el usuario, PayLoad ofrece una plataforma confiable y preparada para el futuro.<\\/p>"},"ar":{"title":"\\u0643\\u064a\\u0641 \\u064a\\u0639\\u0645\\u0644 PayLoad \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0633\\u064a\\u0637 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629","description":"<p>\\u062a\\u0633\\u062a\\u0641\\u064a\\u062f PayLoad \\u0645\\u0646 \\u062a\\u0642\\u0646\\u064a\\u0627\\u062a \\u0627\\u0644\\u0648\\u064a\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631\\u0629 \\u0644\\u062a\\u0648\\u0641\\u064a\\u0631 \\u0645\\u0646\\u0635\\u0629 \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0644\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u0627\\u0644\\u0623\\u062c\\u0647\\u0632\\u0629 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629 \\u0648\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629. \\u0641\\u064a \\u062c\\u0648\\u0647\\u0631\\u0647\\u060c \\u0641\\u0647\\u0648 \\u0645\\u0628\\u0646\\u064a \\u0639\\u0644\\u0649 \\u0625\\u0637\\u0627\\u0631 \\u0639\\u0645\\u0644 PHP \\u0642\\u0648\\u064a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0623\\u062f\\u0627\\u0621 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a \\u0648\\u0642\\u0627\\u0628\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0633\\u0639. \\u0645\\u0639 \\u0648\\u0627\\u062c\\u0647\\u0627\\u062a \\u0628\\u0631\\u0645\\u062c\\u0629 \\u062a\\u0637\\u0628\\u064a\\u0642\\u0627\\u062a RESTful\\u060c \\u064a\\u062a\\u0643\\u0627\\u0645\\u0644 PayLoad \\u0645\\u0639 \\u0628\\u0648\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0648\\u0645\\u0634\\u063a\\u0644\\u064a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0648\\u0641\\u0631 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a.&nbsp;<br>\\u062a\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u062a\\u0642\\u0646\\u064a\\u0627\\u062a \\u062a\\u0634\\u0641\\u064a\\u0631 \\u0645\\u062a\\u0642\\u062f\\u0645\\u0629 \\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a\\u060c \\u0645\\u0639 \\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0628\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629. \\u0648\\u064a\\u0636\\u0645\\u0646 \\u062a\\u0635\\u0645\\u064a\\u0645\\u0647 \\u0633\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0633\\u0647\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0623\\u062c\\u0647\\u0632\\u0629\\u060c \\u0633\\u0648\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0633\\u0637\\u062d \\u0627\\u0644\\u0645\\u0643\\u062a\\u0628 \\u0623\\u0648 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644. \\u062a\\u0645 \\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0627\\u0644\\u062e\\u0644\\u0641\\u064a\\u0629 \\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0627\\u0644\\u0643\\u0641\\u0627\\u0621\\u0629\\u060c \\u0648\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0632\\u0627\\u0645\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u062f\\u0648\\u0646 \\u062a\\u0623\\u062e\\u064a\\u0631.&nbsp;<br>\\u062a\\u0633\\u0647\\u0644 \\u0648\\u0627\\u062c\\u0647\\u0629 PayLoad \\u0627\\u0644\\u0628\\u062f\\u064a\\u0647\\u064a\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u0647\\u0648\\u0627\\u062a\\u0641\\u0647\\u0645 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629 \\u0623\\u0648 \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0628\\u0628\\u0636\\u0639 \\u0646\\u0642\\u0631\\u0627\\u062a \\u0641\\u0642\\u0637. \\u062a\\u0648\\u0641\\u0631 \\u0644\\u0648\\u062d\\u0629 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u062a\\u062d\\u0644\\u064a\\u0644\\u0627\\u062a \\u0634\\u0627\\u0645\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0627\\u0639\\u062f \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062a\\u0628\\u0639 \\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u0623\\u062f\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0628\\u064a\\u0639\\u0627\\u062a.&nbsp;<br>\\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062c\\u0645\\u0639 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0648\\u0627\\u0644\\u062a\\u0635\\u0645\\u064a\\u0645 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0631\\u0643\\u0632 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u060c \\u062a\\u0648\\u0641\\u0631 PayLoad \\u0645\\u0646\\u0635\\u0629 \\u0645\\u0648\\u062b\\u0648\\u0642\\u0629 \\u0648\\u062c\\u0627\\u0647\\u0632\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0642\\u0628\\u0644.<\\/p>"}},"image":"899c614c-a7f6-4c71-bd2b-45323de10bbc.webp"}','status' => '1','created_at' => '2024-12-11 15:25:52','updated_at' => '2024-12-11 15:55:12'),
  array('id' => '6','admin_id' => '1','category_id' => '4','slug' => 'why-payload-is-your-trusted-partner-for-recharges-and-gifting','data' => '{"language":{"en":{"title":"Why PayLoad is Your Trusted Partner for Recharges and Gifting","description":"<p>In today\\u2019s fast-paced world, convenience is key. PayLoad is designed to simplify how users handle mobile recharges and purchase digital gift cards. But what makes it stand out?<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Ease of Use:<\\/strong> With its straightforward navigation and intuitive layout, anyone can recharge or buy a gift card within seconds.<\\/li><li><strong>Instant Transactions:<\\/strong> Powered by real-time processing, PayLoad ensures transactions are completed without delay.<\\/li><li><strong>Secure Payments:<\\/strong> Utilizing encryption and PCI-DSS-compliant payment gateways, the platform prioritizes user safety.<\\/li><li><strong>Wide Range of Options:<\\/strong> From telecom providers to popular gift card brands, PayLoad offers a comprehensive selection.<\\/li><li><strong>User-Centric Features:<\\/strong> Keep track of past transactions, manage accounts, and receive instant notifications\\u2014all in one place.<\\/li><\\/ol><p>PayLoad isn\\u2019t just another platform; it\\u2019s a tool designed to enhance your digital lifestyle. Say goodbye to long queues and unreliable services\\u2014switch to PayLoad today!<\\/p>","tags":["Offer"]},"fr":{"title":"Pourquoi PayLoad est votre partenaire de confiance pour les recharges et les cadeaux","description":"<p>Dans le monde rapide d\\u2019aujourd\\u2019hui, la commodit\\u00e9 est essentielle. PayLoad est con\\u00e7u pour simplifier la gestion des recharges mobiles et l\'achat de cartes-cadeaux num\\u00e9riques. Mais qu\\u2019est-ce qui le distingue ?<\\/p><ul><li><strong>Facilit\\u00e9 d\\u2019Utilisation<\\/strong> : Gr\\u00e2ce \\u00e0 une navigation simple et une interface intuitive, tout le monde peut recharger ou acheter une carte-cadeau en quelques secondes.<\\/li><li><strong>Transactions Instantan\\u00e9es<\\/strong> : Aliment\\u00e9 par un traitement en temps r\\u00e9el, PayLoad garantit que les transactions sont effectu\\u00e9es sans d\\u00e9lai.<\\/li><li><strong>Paiements S\\u00e9curis\\u00e9s<\\/strong> : En utilisant le cryptage et des passerelles de paiement conformes \\u00e0 PCI-DSS, la plateforme met la s\\u00e9curit\\u00e9 des utilisateurs au premier plan.<\\/li><li><strong>Large Gamme d\\u2019Options<\\/strong> : Des fournisseurs de t\\u00e9l\\u00e9communications aux marques populaires de cartes-cadeaux, PayLoad propose une s\\u00e9lection compl\\u00e8te.<\\/li><li><strong>Fonctionnalit\\u00e9s Ax\\u00e9es sur l\\u2019Utilisateur<\\/strong> : Suivez vos transactions pass\\u00e9es, g\\u00e9rez vos comptes et recevez des notifications instantan\\u00e9es, le tout au m\\u00eame endroit.<\\/li><\\/ul><p>PayLoad n\\u2019est pas simplement une autre plateforme ; c\\u2019est un outil con\\u00e7u pour am\\u00e9liorer votre mode de vie num\\u00e9rique. Dites adieu aux longues files d\\u2019attente et aux services peu fiables : passez \\u00e0 PayLoad d\\u00e8s aujourd\\u2019hui !<\\/p>"},"es":{"title":"Por qu\\u00e9 PayLoad es su socio de confianza para recargas y regalos","description":"<p>En el mundo acelerado de hoy, la conveniencia es clave. PayLoad est\\u00e1 dise\\u00f1ado para simplificar c\\u00f3mo los usuarios manejan las recargas m\\u00f3viles y compran tarjetas de regalo digitales. Pero, \\u00bfqu\\u00e9 lo hace destacar?<\\/p><ul><li><strong>Facilidad de Uso<\\/strong>: Con una navegaci\\u00f3n sencilla y un dise\\u00f1o intuitivo, cualquiera puede recargar o comprar una tarjeta de regalo en segundos.<\\/li><li><strong>Transacciones Instant\\u00e1neas<\\/strong>: Impulsado por un procesamiento en tiempo real, PayLoad asegura que las transacciones se completen sin demoras.<\\/li><li><strong>Pagos Seguros<\\/strong>: Utilizando cifrado y pasarelas de pago compatibles con PCI-DSS, la plataforma prioriza la seguridad del usuario.<\\/li><li><strong>Amplia Gama de Opciones<\\/strong>: Desde proveedores de telecomunicaciones hasta marcas populares de tarjetas de regalo, PayLoad ofrece una selecci\\u00f3n integral.<\\/li><li><strong>Caracter\\u00edsticas Centradas en el Usuario<\\/strong>: Realiza un seguimiento de las transacciones pasadas, administra cuentas y recibe notificaciones instant\\u00e1neas, todo en un solo lugar.<\\/li><\\/ul><p>PayLoad no es solo otra plataforma; es una herramienta dise\\u00f1ada para mejorar tu estilo de vida digital. Di adi\\u00f3s a las largas filas y a los servicios poco confiables: \\u00a1c\\u00e1mbiate a PayLoad hoy!<\\/p>"},"ar":{"title":"\\u0644\\u0645\\u0627\\u0630\\u0627 \\u062a\\u0639\\u062a\\u0628\\u0631 PayLoad \\u0634\\u0631\\u064a\\u0643\\u0643 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642 \\u0628\\u0647 \\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0634\\u062d\\u0646 \\u0648\\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627","description":"<p>\\u0641\\u064a \\u0639\\u0627\\u0644\\u0645 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0625\\u064a\\u0642\\u0627\\u0639\\u060c \\u0627\\u0644\\u0631\\u0627\\u062d\\u0629 \\u0647\\u064a \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633. \\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 PayLoad \\u0644\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0644\\u0634\\u062d\\u0646 \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629 \\u0648\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629. \\u0648\\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u064a\\u0632\\u0647\\u061f<\\/p><ul><li><strong>\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645<\\/strong>: \\u0628\\u0641\\u0636\\u0644 \\u0648\\u0627\\u062c\\u0647\\u062a\\u0647 \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u062a\\u0635\\u0645\\u064a\\u0645\\u0647 \\u0627\\u0644\\u0633\\u0647\\u0644\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0634\\u062e\\u0635 \\u0634\\u062d\\u0646 \\u0647\\u0627\\u062a\\u0641\\u0647 \\u0623\\u0648 \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u064a\\u0629 \\u0641\\u064a \\u062b\\u0648\\u0627\\u0646\\u064d.<\\/li><li><strong>\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0641\\u0648\\u0631\\u064a\\u0629<\\/strong>: \\u0645\\u0639 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u060c \\u064a\\u0636\\u0645\\u0646 PayLoad \\u0625\\u062a\\u0645\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u062f\\u0648\\u0646 \\u0623\\u064a \\u062a\\u0623\\u062e\\u064a\\u0631.<\\/li><li><strong>\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0622\\u0645\\u0646\\u0629<\\/strong>: \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631 \\u0648\\u0628\\u0648\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0627\\u0641\\u0642\\u0629 \\u0645\\u0639 PCI-DSS\\u060c \\u062a\\u064f\\u0639\\u0637\\u0649 \\u0623\\u0648\\u0644\\u0648\\u064a\\u0629 \\u0642\\u0635\\u0648\\u0649 \\u0644\\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646.<\\/li><li><strong>\\u062a\\u0634\\u0643\\u064a\\u0644\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a<\\/strong>: \\u0645\\u0646 \\u0645\\u0632\\u0648\\u062f\\u064a \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0647\\u064a\\u0631\\u0629 \\u0644\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u064a\\u0648\\u0641\\u0631 PayLoad \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0634\\u0627\\u0645\\u0644\\u0629.<\\/li><li><strong>\\u0645\\u064a\\u0632\\u0627\\u062a \\u0645\\u0648\\u062c\\u0647\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645<\\/strong>: \\u062a\\u062a\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0633\\u0627\\u0628\\u0642\\u0629\\u060c \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u060c \\u0648\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0641\\u0648\\u0631\\u064a\\u0629\\u2014\\u0643\\u0644 \\u0630\\u0644\\u0643 \\u0641\\u064a \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0627\\u062d\\u062f.<\\/li><\\/ul><p>PayLoad \\u0644\\u064a\\u0633 \\u0645\\u062c\\u0631\\u062f \\u0645\\u0646\\u0635\\u0629 \\u0623\\u062e\\u0631\\u0649\\u061b \\u0628\\u0644 \\u0647\\u0648 \\u0623\\u062f\\u0627\\u0629 \\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0623\\u0633\\u0644\\u0648\\u0628 \\u062d\\u064a\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a. \\u0642\\u0644 \\u0648\\u062f\\u0627\\u0639\\u0627\\u064b \\u0644\\u0644\\u0637\\u0648\\u0627\\u0628\\u064a\\u0631 \\u0627\\u0644\\u0637\\u0648\\u064a\\u0644\\u0629 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629\\u2014\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 PayLoad \\u0627\\u0644\\u064a\\u0648\\u0645!<\\/p>"}},"image":"e197d6fe-7406-44cb-824e-07e70009c112.webp"}','status' => '1','created_at' => '2024-12-11 15:35:01','updated_at' => '2024-12-11 16:23:53'),
  array('id' => '7','admin_id' => '1','category_id' => '3','slug' => 'getting-the-most-out-of-payload-a-user-guide','data' => '{"language":{"en":{"title":"Getting the Most Out of PayLoad: A User Guide","description":"<p>If you\'re new to PayLoad or looking to make the most of it, here are some tips:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Set Up Your Account Properly:<\\/strong> Register with your email or phone number for a personalized experience.<\\/li><li><strong>Explore Payment Options:<\\/strong> PayLoad supports multiple payment methods, including credit\\/debit cards, UPI, and wallets. Choose the one that suits you best.<\\/li><li><strong>Use Notifications:<\\/strong> Stay updated with transaction confirmations and special offers by enabling notifications.<\\/li><li><strong>Save Your Favorites:<\\/strong> Recharging the same number or buying the same gift card repeatedly? Save them for faster access.<\\/li><li><strong>Check Transaction History:<\\/strong> Use the history feature to review past payments and ensure everything is in order.<\\/li><\\/ol><p>PayLoad is designed to be intuitive, but these tips can enhance your experience even further. Dive in and discover how PayLoad can simplify your everyday digital transactions.<\\/p>","tags":["News"]},"fr":{"title":"Tirer le Meilleur de PayLoad : Un Guide pour l\\u2019Utilisateur","description":"<p>Si vous \\u00eates nouveau sur PayLoad ou souhaitez en tirer le meilleur parti, voici quelques conseils :<\\/p><ul><li><strong>Configurez Votre Compte Correctement<\\/strong> : Inscrivez-vous avec votre adresse e-mail ou votre num\\u00e9ro de t\\u00e9l\\u00e9phone pour une exp\\u00e9rience personnalis\\u00e9e.<\\/li><li><strong>Explorez les Options de Paiement<\\/strong> : PayLoad prend en charge plusieurs m\\u00e9thodes de paiement, notamment les cartes de cr\\u00e9dit\\/d\\u00e9bit, UPI et les portefeuilles num\\u00e9riques. Choisissez celle qui vous convient le mieux.<\\/li><li><strong>Utilisez les Notifications<\\/strong> : Restez inform\\u00e9 des confirmations de transaction et des offres sp\\u00e9ciales en activant les notifications.<\\/li><li><strong>Enregistrez Vos Favoris<\\/strong> : Rechargez-vous le m\\u00eame num\\u00e9ro ou achetez-vous souvent la m\\u00eame carte-cadeau ? Enregistrez-les pour un acc\\u00e8s plus rapide.<\\/li><li><strong>Consultez l\\u2019Historique des Transactions<\\/strong> : Utilisez la fonction historique pour revoir les paiements pass\\u00e9s et vous assurer que tout est en ordre.<\\/li><\\/ul><p>PayLoad est con\\u00e7u pour \\u00eatre intuitif, mais ces conseils peuvent encore am\\u00e9liorer votre exp\\u00e9rience. Plongez dedans et d\\u00e9couvrez comment PayLoad peut simplifier vos transactions num\\u00e9riques quotidiennes !<\\/p>"},"es":{"title":"Aprovecha al M\\u00e1ximo PayLoad: Una Gu\\u00eda para el Usuario","description":"<p>Si eres nuevo en PayLoad o buscas sacarle el m\\u00e1ximo provecho, aqu\\u00ed tienes algunos consejos:<\\/p><ul><li><strong>Configura Tu Cuenta Correctamente<\\/strong>: Reg\\u00edstrate con tu correo electr\\u00f3nico o n\\u00famero de tel\\u00e9fono para una experiencia personalizada.<\\/li><li><strong>Explora las Opciones de Pago<\\/strong>: PayLoad admite m\\u00faltiples m\\u00e9todos de pago, incluidos tarjetas de cr\\u00e9dito\\/d\\u00e9bito, UPI y monederos electr\\u00f3nicos. Elige el que mejor se adapte a ti.<\\/li><li><strong>Usa Notificaciones<\\/strong>: Mantente al d\\u00eda con confirmaciones de transacciones y ofertas especiales activando las notificaciones.<\\/li><li><strong>Guarda Tus Favoritos<\\/strong>: \\u00bfRecargas el mismo n\\u00famero o compras la misma tarjeta de regalo con frecuencia? Gu\\u00e1rdalos para un acceso m\\u00e1s r\\u00e1pido.<\\/li><li><strong>Revisa el Historial de Transacciones<\\/strong>: Usa la funci\\u00f3n de historial para revisar pagos anteriores y asegurarte de que todo est\\u00e9 en orden.<\\/li><\\/ul><p>PayLoad est\\u00e1 dise\\u00f1ado para ser intuitivo, pero estos consejos pueden mejorar a\\u00fan m\\u00e1s tu experiencia. \\u00a1Explora y descubre c\\u00f3mo PayLoad puede simplificar tus transacciones digitales diarias!<\\/p>"},"ar":{"title":"\\u0627\\u0644\\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0642\\u0635\\u0648\\u0649 \\u0645\\u0646 PayLoad: \\u062f\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645","description":"<p>\\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u062c\\u062f\\u064a\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 PayLoad \\u0623\\u0648 \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u062a\\u062d\\u0642\\u064a\\u0642 \\u0623\\u0642\\u0635\\u0649 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0629 \\u0645\\u0646\\u0647\\u060c \\u0625\\u0644\\u064a\\u0643 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0646\\u0635\\u0627\\u0626\\u062d:<\\/p><ul><li><strong>\\u0625\\u0639\\u062f\\u0627\\u062f \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0635\\u062d\\u064a\\u062d<\\/strong>: \\u0642\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0631\\u064a\\u062f\\u0643 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0623\\u0648 \\u0631\\u0642\\u0645 \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0644\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0634\\u062e\\u0635\\u064a\\u0629.<\\/li><li><strong>\\u0627\\u0633\\u062a\\u0643\\u0634\\u0627\\u0641 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639<\\/strong>: \\u064a\\u062f\\u0639\\u0645 PayLoad \\u0637\\u0631\\u0642 \\u062f\\u0641\\u0639 \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\/\\u0627\\u0644\\u062e\\u0635\\u0645\\u060c \\u0648UPI\\u060c \\u0648\\u0627\\u0644\\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629. \\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0646\\u0627\\u0633\\u0628\\u0643.<\\/li><li><strong>\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a<\\/strong>: \\u0643\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0637\\u0644\\u0627\\u0639 \\u062f\\u0627\\u0626\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u062a\\u0641\\u0639\\u064a\\u0644 \\u0627\\u0644\\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a.<\\/li><li><strong>\\u062d\\u0641\\u0638 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0627\\u062a<\\/strong>: \\u0647\\u0644 \\u062a\\u0642\\u0648\\u0645 \\u0628\\u0634\\u062d\\u0646 \\u0646\\u0641\\u0633 \\u0627\\u0644\\u0631\\u0642\\u0645 \\u0623\\u0648 \\u0634\\u0631\\u0627\\u0621 \\u0646\\u0641\\u0633 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0628\\u0627\\u0646\\u062a\\u0638\\u0627\\u0645\\u061f \\u0642\\u0645 \\u0628\\u062d\\u0641\\u0638\\u0647\\u0627 \\u0644\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0623\\u0633\\u0631\\u0639.<\\/li><li><strong>\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0633\\u062c\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a<\\/strong>: \\u0627\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u0633\\u062c\\u0644 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u0633\\u0627\\u0628\\u0642\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0639\\u0644\\u0649 \\u0645\\u0627 \\u064a\\u0631\\u0627\\u0645.<\\/li><\\/ul><p>\\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 PayLoad \\u0644\\u064a\\u0643\\u0648\\u0646 \\u0633\\u0647\\u0644 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u060c \\u0648\\u0644\\u0643\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0646\\u0635\\u0627\\u0626\\u062d \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0639\\u0632\\u0632 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0623\\u0643\\u0628\\u0631. \\u0627\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0622\\u0646 \\u0648\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0640 PayLoad \\u062a\\u0628\\u0633\\u064a\\u0637 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645\\u064a\\u0629!<\\/p>"}},"image":"ea8effcc-21c4-4429-8f2e-6c4632c50f2c.webp"}','status' => '1','created_at' => '2024-12-11 15:42:00','updated_at' => '2024-12-11 15:58:09')
        );

        Blogs::insert($blogs);
    }
}
